# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.


## Generative AI (GenAI) Settings section


## Chatbot prompts
## Prompts are plain language ‘instructions’ sent to a chatbot.
## These prompts have been made concise and direct in English because some chatbot providers
## have character restrictions and being direct reduces the chance for misinterpretation.
## When localizing, please be concise and direct, but not at the expense of losing meaning.


## Chatbot menu shortcuts

# $provider (string) - name of the provider
genai-menu-ask-provider =
    .label = Goulenn digant { $provider }
# $provider (string) - name of the provider
genai-menu-open-provider =
    .label = Digeriñ { $provider }
# $provider (string) - name of the provider
genai-menu-remove-provider =
    .label = Lemel { $provider }
genai-menu-new-badge = Nevez
# $provider (string) - name of the provider
genai-input-ask-provider =
    .placeholder = Goulenn digant { $provider }…

## Chatbot header

genai-header-options-button =
    .title = Digeriñ al lañser
genai-header-close-button =
    .title = Serriñ
# $provider (string) - name of the provider
genai-options-reload-provider =
    .label = Adkargañ { $provider }

## Chatbot footer


## Chatbot onboarding

genai-onboarding-primary = Kenderc’hel
genai-onboarding-secondary = Serriñ
genai-onboarding-claude-tooltip =
    .title = Anthropic Claude
genai-onboarding-claude-learn = Gouzout hiroc’h diwar-benn Claude
genai-onboarding-chatgpt-tooltip =
    .title = ChatGPT
genai-onboarding-chatgpt-learn = Gouzout hiroc’h diwar-benn ChatGPT
genai-onboarding-copilot-tooltip =
    .title = Copilot
genai-onboarding-gemini-tooltip =
    .title = Google Gemini
genai-onboarding-gemini-learn = Gouzout hiroc’h diwar-benn Gemini
genai-onboarding-huggingchat-tooltip =
    .title = HuggingChat
genai-onboarding-huggingchat-learn = Gouzout hiroc’h diwar-benn HuggingChat
genai-onboarding-lechat-tooltip =
    .title = Le Chat Mistral
genai-onboarding-lechat-learn = Gouzout hiroc’h diwar-benn Le Chat

## Chatbot onboarding choices
## These describe features/capabilities of chatbot providers. These are not buttons/actions.

genai-onboarding-claude-analyze = Dielfennañ teulioù ha skeudennoù
genai-onboarding-chatgpt-analyze = Dielfennañ teulioù ha skeudennoù
genai-onboarding-copilot-analyze = Dielfennañ skeudennoù
genai-onboarding-gemini-analyze = Dielfennañ skeudennoù (digoust) ha teulioù (da baeañ)

## Model Optin Component

genai-model-optin-continue =
    .label = Kenderc’hel
genai-model-optin-optout =
    .label = Nullañ
genai-model-optin-cancel =
    .label = Nullañ

## Link previews

